Attribute VB_Name = "modUpdateEdit"
Option Explicit

Public Const TitleString = "The Odyssey Online Update Editor"

Type OptionData
    SourcePath As String
    DestPath As String
    PKZip As String
    Zip2Exe As String
End Type

Public Options As OptionData

Public LatestVersion As String

Public colLatestFiles As New Collection

Public CurrentFile As clsFile

Public ReturnValue As String

Public Section(1 To 4) As String

'INI File Related
Declare Function GetPrivateProfileInt Lib "kernel32" Alias "GetPrivateProfileIntA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName As String) As Long
Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long

'Shell Related
Declare Function OpenProcess Lib "kernel32" (ByVal dwDesiredAccess As Long, ByVal bInheritHandle As Long, ByVal dwProcessId As Long) As Long
Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Declare Function WaitForSingleObject Lib "kernel32" (ByVal hHandle As Long, ByVal dwMilliseconds As Long) As Long
Public Const SYNCHRONIZE = &H100000
Public Const INFINITE = &HFFFFFFFF

Sub WaitForTerm(pid As Long)
    Dim phnd As Long
    phnd = OpenProcess(SYNCHRONIZE, 0, pid)
    If phnd <> 0 Then
        Call WaitForSingleObject(phnd, INFINITE)
        Call CloseHandle(phnd)
    End If
End Sub

Sub GetSections(St)
    Dim A As Integer, B As Integer, C As Integer
    B = 1
    Erase Section
    For A = 1 To 4
TryAgain:
        C = InStr(B, St, ",")
        If C - B = 0 Then B = B + 1: GoTo TryAgain
        If C <> 0 Then
                Section(A) = Mid$(St, B, C - B)
        Else
                Section(A) = Mid$(St, B, Len(St) - B + 1)
                Exit For
        End If
        B = C + 1
    Next A
End Sub

Sub Main()
    Dim St As String, File As clsFile

    'Load Options
    With Options
        .SourcePath = ReadString("Options", "SourcePath")
        .DestPath = ReadString("Options", "DestPath")
        .PKZip = ReadString("Options", "PKZip")
        .Zip2Exe = ReadString("Options", "Zip2Exe")
    End With
    
    'Load Update.dat
    If Exists(Options.DestPath + "\update.dat") Then
        Open Options.DestPath + "\update.dat" For Input As #1
        If Not EOF(1) Then Line Input #1, LatestVersion
        While Not EOF(1)
            Line Input #1, St
            GetSections St
            If Section(1) <> "" And Section(2) <> "" And Section(3) <> "" And Section(4) <> "" Then
                If Exists(Options.SourcePath + "\" + Section(1)) Then
                    Set File = New clsFile
                    With File
                        .File = LCase$(Section(1))
                        .Version = Int(Val(Section(2)))
                        .Size = FileLen(Options.SourcePath + "\" + Section(1))
                        If Int(Val(Section(4))) = 0 Then
                            .Compressed = False
                        Else
                            .Compressed = True
                        End If
                    End With
                    colLatestFiles.Add File, File.File
                End If
            End If
        Wend
        Close #1
    End If
    
    frmMain.Show
End Sub
Function ReadInt(lpAppName, lpKeyName$) As Integer
    ReadInt = GetPrivateProfileInt&(lpAppName, lpKeyName$, 0, App.Path + "\updedit.ini")
End Function
Function ReadString(lpAppName, lpKeyName As String) As String
    Dim lpReturnedString As String, Valid As Long
    lpReturnedString = Space$(256)
    Valid = GetPrivateProfileString&(lpAppName, lpKeyName, "", lpReturnedString, 256, App.Path + "\updedit.ini")
    ReadString = Left$(lpReturnedString, Valid)
End Function
Function FilePart(Filename As String) As String
    Dim A As Long
    If Len(Filename) > 0 Then
        For A = Len(Filename) To 1 Step -1
            If Mid$(Filename, A, 1) = "\" Then
                FilePart = Right$(Filename, Len(Filename) - A)
                Exit Function
            End If
        Next A
    End If
    FilePart = Filename
End Function
Sub WriteString(lpAppName, lpKeyName As String, A)
    Dim lpString As String, Valid As Long
    lpString = A
    Valid = WritePrivateProfileString&(lpAppName, lpKeyName, lpString, App.Path + "\updedit.ini")
End Sub
Function Exists(Filename As String) As Boolean
     Exists = (Dir(Filename) <> "")
End Function

